/******************************************************************************/
/*** exe trials materials*******************************************************/
/******************************************************************************/

var exe_list = [
    ["exe_1",["bird_sleep", "dog_bark"]],
    ["exe_2",["dog_run", "lion_run"]],
    ["exe_3",["rabbit_stand", "lion_sleep"]]
  ]
  
  
  /******************************************************************************/
  /*** Saving data trial by trial ***********************************************/
  /******************************************************************************/
  
  /*
  This is the save_data function provided in Alisdair's tutorial, section 06. 
  */
  function save_data(name, data_in) {
    var url = "save_data.php";
    var data_to_send = { filename: name, filedata: data_in };
    fetch(url, {
      method: "POST",
      body: JSON.stringify(data_to_send),
      headers: new Headers({
        "Content-Type": "application/json",
      }),
    });
  }
  
  function save_questionnaire_data(data_to_save, headers = '') {
    var line = headers + data_to_save.join(",") + ",";
    var this_participant_filename = "mochi_" + participant_id + "_questionnaire.csv";
    save_data(this_participant_filename, line);
  }
  
  /*
  This is a slightly modification to Alisdair's saveDataLine code. Note that data is
  save to a file named cp_ID.csv, where cp stands for confederate priming and ID is
  the randomly-generated participant ID.
  
  We have to check which trial type we are selecting data for, since picture_description 
  trials lack a button_choices and button_selected entries. There's also no point 
  saving the data.response info for picture_description trials, since it just indicates 
  the participant clicking on the mic button, so we will save "NA" for those missing values.
  
  For picture_selection trials, data.button_choices will be a list of 4 image names - 
  here I am using .join to turn that list into a single string for writing, rather than doing 
  e.g. data.button_choices[0], data.button_choices[1], data.button_choices[2], etc to
  write all those choices to the CSV.
  */
  function save_confederate_priming_data(data) {
    // choose the data we want to save - this will also determine the order of the columns
    if (data.participant_task == "picture_selection"|| "exercise") {
      var button_choices_as_string = data.button_choices.join(",");
      var data_to_save = [
        participant_id,
        data.trial_index,
        data.participant_task,
        data.stimulus,
        button_choices_as_string,
        data.response,
        data.button_selected,
        data.rt,
      ];
    }
    // join these with commas and add a newline
    var line = data_to_save.join(",") + "\n";
    var this_participant_filename = "mochi_" + participant_id + ".csv";
    save_data(this_participant_filename, line);
  }
  
  /******************************************************************************/
  /*** Generate a random participant ID *****************************************/
  /******************************************************************************/
  
  /*
  We'll generate a random participant ID when the experiment starts, and use this
  to save a seperate set of data files per participant.
  */
  
  var participant_id = jsPsych.randomization.randomID(10);
  
  /******************************************************************************/
  /*** Flipping images ***************************************************/
  /******************************************************************************/
  
  /*
  The images folder contains two versions of each image - the orientation they were
  drawn in, and then a reversed image where the image is flipped on its horizontal
  axis - the two images have the same name except that the reversed image has "_r"
  added at the end. Since the order the characters and objects appear in a scene might
  influence how people talk about them, we want to rndomise this whenever these images
  appear, which is done by this random_image_flip function, which takes an image name
  and either returns that image name or the reversed version, by adding "_r" to the
  end of the image name.
  */
  function random_image_flip(image_name) {
    var image_affixes = ["", "_r"];
    var selected_affix = jsPsych.randomization.shuffle(image_affixes)[0];
    var new_image_name = image_name + selected_affix;
    return new_image_name;
  }
  
   
  /******************************************************************************/
  /*** Dialect background questionnaire *********************************************/
  /******************************************************************************/
  
  var likert_scale_2 = [
    "（几乎）从未",
    "至少一周一次",
    "每天"  
  ];
  
  var dialect_background_questionnaire = {
    type: "survey-html-form",
    preamble:
      "<p style='text-align:left'> <h3>语言背景问卷</h3></p>\
                <p style='text-align:left'> <b>在这份问卷中，我们需要收集您孩子语言背景的相关信息。 \
                这份问卷包括两个部分（A&B），预计需要3分钟完成。  </b></p>" ,
    html: "<p style='text-align:left'>A1. 您孩子的年龄是？ <br> \
                岁数: <input min=4 max= 15 required name='year' type='number'>\
                月份: <input min=1 max= 12 required name='month' type='number'></p> \
           <p style='text-align:left'>A2. 您孩子的性别是？ <br> \
                <input required type='radio' name='gender' value='Male'>男<br>\
                <input required type='radio' name='gender' value='Female'>女<br>\
                <input required type='radio' name='gender' value='Other'>其他<br>\
           <p style='text-align:left'>A3. 您孩子会说除英语和汉语以外的语言吗？若符合，请输入该语言。若不符合，请输入“无”并跳过A3.1。 <br> \
                <input required name='language' type='text'></p>\
           <p style='text-align:left'>A3.1. 您的孩子从以下哪些途径接触<b>该语言</b>？ <br> \
                <input type='radio' name='exposure' value='family'>他/她对父母的其中一方（或其他家庭成员）使用该语言（包括说和听），并使用至少一周一次。<br>\
                <input type='radio' name='exposure' value='school'>他/她（曾）在双语/多语幼儿园或小学就读<br>\
                <input type='radio' name='exposure' value='both'>以上皆是<br>\
                <input type='radio' name='exposure' value='other'> 其他，请说明：\
                <input name='other_exposure' type='text' size='100'></p>",
    button_label: "下一页",
    on_finish: function (data) {
      var questionnaire_data = data.response;
      var data_to_save = [
        participant_id,
        questionnaire_data.year,
        questionnaire_data.month,
        questionnaire_data.gender,
        questionnaire_data.language,
        questionnaire_data.exposure,
        questionnaire_data.other_exposure
      ];
      var headers = "id,A1_age_year,A1_age_month,A2_gender,A3_language, A4_exposure, A3_1_other_exposure,\
      B1_current_school, B1_current_grade, B2_exposure_school,\
      C1_E_reading, C1_E_digital, C1_E_internet, C1_E_phone, C1_E_Skype, C1_E_movie, C1_E_music,\
      C2_M_reading, C2_M_digital, C2_M_internet, C2_M_phone, C2_M_Skype, C2_M_movie, C2_M_music\n";
      save_questionnaire_data(data_to_save,headers);
    },
  };
  
  
  var dialect_background_questionnaire_1 = {
    type: "survey-html-form",
    html: "<p style='text-align:left'>B1. 您孩子现在的年级是？ <br> \
                <input required type='radio' name='school' value='primary'>小学<br>\
                <input required type='radio' name='school' value='secondary'>中学<br>\
                年级（1-9） <input required min=1 max= 6 name='grade' type='number'> <br>\
           <p style='text-align:left'>B2. 您孩子在学校接触多少英语？<br> \
                <input required type='radio' name='program' value='4'>他/她在全英项目就读。<br>\
                <input required type='radio' name='program' value='3'>他/她中英双语项目就读。<br>\
                <input required type='radio' name='program' value='2'>他/她只在英语课上接受正式的英语教学。 <br>\
                <input required type='radio' name='program' value='1'>他/她在学校没有（或很少）接受正式英语教学，但他/她在校外上英语课。<br>\
                <input required type='radio' name='program' value='0'>他/她没有（或很少）接受正式英语教学<br>",
    button_label: "下一页",
    on_finish: function (data) {
      var questionnaire_data = data.response;
      var data_to_save = [
        questionnaire_data.school,
        questionnaire_data.grade,
        questionnaire_data.program,
      ];
      save_questionnaire_data(data_to_save);
    },
  };
  
  var dialect_background_questionnaire_2 = {
    type: "survey-likert",
    preamble: "C1.您孩子每周进行哪些以下<b>英语</b>读写及课外活动？",
    questions: [
        {prompt: "读书或报刊", name: 'extra_E_read', labels: likert_scale_2, required: true},
        {prompt: "线上语言学习(多邻国等)", name: 'extra_E_digital', labels: likert_scale_2, required: true},
        {prompt: "社交媒体(小红书，微博，抖音，Facebook，Twitter等)", name: 'extra_E_internet', labels: likert_scale_2, required: true},
        {prompt: "手机（打电话或发短信）", name: 'extra_E_phone', labels: likert_scale_2, required: true},
        {prompt: "视频电话", name: 'extra_E_skype', labels: likert_scale_2,required: true},
        {prompt: "电影/电视剧", name: 'extra_E_movie', labels: likert_scale_2,required: true},
        {prompt: "音乐", name: 'extra_E_music', labels: likert_scale_2,required: true},
    ],
    button_label: "下一页",
    on_finish: function (data) {
      var questionnaire_data = data.response;
      var data_to_save = [
        questionnaire_data.extra_E_read,
        questionnaire_data.extra_E_digital,
        questionnaire_data.extra_E_internet,
        questionnaire_data.extra_E_phone,
        questionnaire_data.extra_E_skype,
        questionnaire_data.extra_E_movie,
        questionnaire_data.extra_E_music,
      ];
      save_questionnaire_data(data_to_save);
    },
  };
  
  var dialect_background_questionnaire_3 = {
    type: "survey-likert",
    preamble: "C2. 您孩子每周进行哪些以下<b>普通话</b>读写及课外活动？",
    questions: [
        {prompt: "读书或报刊", name: 'extra_M_read', labels: likert_scale_2, required: true},
        {prompt: "线上语言学习(多邻国等)", name: 'extra_M_digital', labels: likert_scale_2, required: true},
        {prompt: "社交媒体(微博，抖音，小红书，Facebook，Twitter等)", name: 'extra_M_internet', labels: likert_scale_2, required: true},
        {prompt: "手机（打电话或发短信）", name: 'extra_M_phone', labels: likert_scale_2, required: true},
        {prompt: "视频电话", name: 'extra_M_skype', labels: likert_scale_2,required: true},
        {prompt: "电影/电视剧", name: 'extra_M_movie', labels: likert_scale_2,required: true},
        {prompt: "音乐", name: 'extra_M_music', labels: likert_scale_2,required: true},
    ],
    button_label: "完成",
    on_finish: function (data) {
      var questionnaire_data = data.response;
      var data_to_save = [
        questionnaire_data.extra_M_read,
        questionnaire_data.extra_M_digital,
        questionnaire_data.extra_M_internet,
        questionnaire_data.extra_M_phone,
        questionnaire_data.extra_M_skype,
        questionnaire_data.extra_M_movie,
        questionnaire_data.extra_M_music,
      ];
      save_questionnaire_data(data_to_save);
    },
  };
  
  /******************************************************************************/
  /*** Picture selection trials *************************************************/
  /******************************************************************************/
  
  function make_picture_selection_trial(sound, images) {
    var sound_file = "sounds/" + sound + ".mp3";
    var image_choices = [];
    for (image of images) {
      image_choices.push(random_image_flip(image));
      var image_choices = jsPsych.randomization.shuffle(image_choices)
      //console.log(image_choices)
    }
  
    //audio trial
    var selection_trial = {
      type: "audio-button-response",
      stimulus: sound_file,
      choices: image_choices,
      button_html:
        ['<button class="jspsych-btn" style = "position:sticky; left:180px; top: 150px"> <img src="images/%choice%.png" width=500px></button>',
        '<button class="jspsych-btn" style = "position:sticky; right:180px; top: 150px"> <img src="images/%choice%.png" width=500px></button>',
        '<button class="jspsych-btn" style = "position:absolute; left:670px; top: 600px"> <img src="images/%choice%.png" width=45px></button>'],
      response_allowed_while_playing: false, //participant can't make choices before the audio finishes playing
      post_trial_gap: 500, //a little pause after the participant makes their choice
      on_start: function (trial) {
        var shuffled_image_choices = trial.choices;
        var shuffled_image_choices_mic = [...shuffled_image_choices,"sound"];
        trial.choices = shuffled_image_choices_mic;
        trial.data = {
          participant_task: "picture_selection",
          button_choices: shuffled_image_choices_mic,
        };
      },
      on_finish: function (data) {
        var button_number = data.response;
        data.button_selected = data.button_choices[button_number];
        save_confederate_priming_data(data); //save the trial data
      },
    };
  
    var selection_trial_2 = {
      type: "audio-button-response",
      stimulus: sound_file,
      choices: image_choices,
      button_html:
        ['<button class="jspsych-btn" style = "position:sticky; left:180px; top: 150px"> <img src="images/%choice%.png" width=500px></button>',
        '<button class="jspsych-btn" style = "position:sticky; right:180px; top: 150px"> <img src="images/%choice%.png" width=500px></button>'],
      response_allowed_while_playing: false, //participant can't make choices before the audio finishes playing
      post_trial_gap: 500, //a little pause after the participant makes their choice
      on_start: function (trial) {
        var shuffled_image_choices = trial.choices;
        trial.data = {
          participant_task: "picture_selection",
          button_choices: [...shuffled_image_choices,"sound"],
        };
      },
      on_finish: function (data) {
        var button_number = data.response;
        data.button_selected = data.button_choices[button_number];
        save_confederate_priming_data(data); //save the trial data
      },
    };
    
    var if_node = {
      timeline: [selection_trial_2],
      conditional_function: function(){
          // get the data from the previous trial,
          // and check which key was pressed
          var data = jsPsych.data.get().last(1).values()[0];
          //console.log(data.response);
          if(data.response == 2){
              return true;
          } else {
              return false;
          }
      }
  };
  
    var full_trial = { timeline: [selection_trial, if_node]
     };
    return full_trial;
  }

  /******************************************************************************/
  /*** Exercise trials *************************************************/
  /******************************************************************************/
  
  function exercise_trial(sound, images) {
    var sound_file = "sounds/" + sound + ".mp3";
    var image_choices = [];
    for (image of images) {
      image_choices.push(random_image_flip(image));
      var image_choices = jsPsych.randomization.shuffle(image_choices)
      //console.log(image_choices)
    }
  
    //audio trial
    var selection_trial = {
      type: "audio-button-response",
      stimulus: sound_file,
      choices: image_choices,
      button_html:
        ['<button class="jspsych-btn" style = "position:sticky; left:180px; top: 150px"> <img src="images/%choice%.png" width=500px></button>',
        '<button class="jspsych-btn" style = "position:sticky; right:180px; top: 150px"> <img src="images/%choice%.png" width=500px></button>',
        '<button class="jspsych-btn" style = "position:absolute; left:670px; top: 600px"> <img src="images/%choice%.png" width=45px></button>'],
      response_allowed_while_playing: false, //participant can't make choices before the audio finishes playing
      post_trial_gap: 500, //a little pause after the participant makes their choice
      on_start: function (trial) {
        var shuffled_image_choices = trial.choices;
        var shuffled_image_choices_mic = [...shuffled_image_choices,"sound"];
        trial.choices = shuffled_image_choices_mic;
        trial.data = {
          participant_task: "exercise",
          button_choices: shuffled_image_choices_mic,
        };
      },
      on_finish: function (data) {
        var button_number = data.response;
        data.button_selected = data.button_choices[button_number];
        save_confederate_priming_data(data); //save the trial data
      },
    };
  
    var selection_trial_2 = {
      type: "audio-button-response",
      stimulus: sound_file,
      choices: image_choices,
      button_html:
        ['<button class="jspsych-btn" style = "position:sticky; left:180px; top: 150px"> <img src="images/%choice%.png" width=500px></button>',
        '<button class="jspsych-btn" style = "position:sticky; right:180px; top: 150px"> <img src="images/%choice%.png" width=500px></button>'],
      response_allowed_while_playing: false, //participant can't make choices before the audio finishes playing
      post_trial_gap: 500, //a little pause after the participant makes their choice
      on_start: function (trial) {
        var shuffled_image_choices = trial.choices;
        trial.data = {
          participant_task: "exercise",
          button_choices: [...shuffled_image_choices,"sound"],
        };
      },
      on_finish: function (data) {
        var button_number = data.response;
        data.button_selected = data.button_choices[button_number];
        save_confederate_priming_data(data); //save the trial data
      },
    };
    
    var if_node = {
      timeline: [selection_trial_2],
      conditional_function: function(){
          // get the data from the previous trial,
          // and check which key was pressed
          var data = jsPsych.data.get().last(1).values()[0];
          //console.log(data.response);
          if(data.response == 2){
              return true;
          } else {
              return false;
          }
      }
  };
  
    var full_trial = { timeline: [selection_trial, if_node]
     };
    return full_trial;
  }
  
  /******************************************************************************/
  /*** Write headers for data file **********************************************/
  /******************************************************************************/
  
  /*
  Same as the perceptual learning practical.
  */
  var write_headers = {
    type: "call-function",
    func: function () {
      var this_participant_filename = "mochi_" + participant_id + ".csv";
      save_data(
        this_participant_filename,
        "participant_id,trial_index,participant_task,stimulus,button_choice0,button_choice1, button_choice3,response,button_selected,rt\n"
      );
    },
  };
  
  /******************************************************************************/
  /*** Instruction trials *******************************************************/
  /******************************************************************************/
  
  /*
  As usual, your experiment will need some instruction screens.
  */
  
  var consent_screen = {
    type: "html-button-response",
    stimulus:
      "<h3>欢迎参与本实验！</h3> \
    <p style='text-align:left'><b>研究题目</b>：句子理解实验 <br>\
    <b>指导老师</b>：Dr Vicky Chondrogianni <br>\
    <b>数据收集者</b>：Shuya Chen</p> \
    <p style='text-align:left'><b>参与邀请：</b> \
    您和您的孩子被邀请参与一项关于句子理解的实验。本文解释了我们正在进行的研究、您的权利以及我们将如何处理您的数据。您可以打印此页作为记录。</p>\
    <p style='text-align:left'> <b>研究说明：</b> \
    研究指出，双语儿童的两种语言之间会互相影响。这项研究旨在探索英语-普通话双语儿童理解普通话句子的方式。为了更好地了解您孩子的语言发展，\
    我们会问您一些关于您孩子语言使用情况的问题。 </p>\
    <p style='text-align:left'><b>实验过程：</b> \
    如果您和您的孩子同意参与这项研究，我们将向你的孩子播放一段短故事，故事播放结束后，\
    您的孩子将在屏幕上看到两张图片，他们需要选择他们认为与故事最匹配的图片。在开始之前，我们会收集有关您孩子的信息，例如年龄，性别以及语言背景。\
    您的回答将会被记录。整个过程预计将持续30分钟。在实验开始之前，我们会确认您的孩子同意参与此项实验，并监督他们想要退出的语言及非语言信号。</p>\
    <p style='text-align:left'><b>被试费：</b> 参与这项实验，您将获得£4等值的人民币作为补偿。</p>\
    <p style='text-align:left'><b>研究风险与收益：</b>\
    本研究对于被试者没有任何已知风险。本研究不会带给您直接收益，但您的参与将为语言及语言学习的研究做出重要贡献。</p>\
    <p style='text-align:left'><b>数据保护与使用：</b> \
    我们在研究过程中收集的所有信息将根据数据保护法进行处理。为了保护您的隐私，我们不会收集除了电子邮件地址以外的任何个人信息。\
    您的电子邮件地址将会用于完成付款流程，在付款流程结束后，我们将会删除您的电子邮件地址。您和您孩子的数据将通过唯一的参与者编号（而不是按姓名）引用。\
    本研究期间收集的匿名数据将用于研究目的，并可能与其他研究者共享。</p>\
    <p style='text-align:left'><b>您的数据保护权：</b> \
    爱丁堡大学是您提供的信息的数据控制者。您有权访问有关您的信息。\
    您可以根据数据保护法行使访问权。您还拥有更正、删除和反对的权利。有关更多详细信息，包括向信息专员办公室提出投诉的权利，\
    请访问 www.ico.org.uk。关于您的个人数据的问题、评论和请求也可以发送给大学数据保护官 dpo@ed.ac.uk。</p>\
    <p style='text-align:left'><b>自愿参加和退出：</b> \
    您的参与是自愿的，您可以在完成实验两周内退出研究。如果您在数据收集期间或之后退出研究，我们将删除您的数据，您亦不会受到任何惩罚或损失。</p>\
    <p style='text-align:left'>如果您对刚刚阅读的内容有任何疑问，请随时提问，或稍后联系我们。您可以通过电子邮件（s2164197@ed.ac.uk）与我们联系。\
    本研究已获得爱丁堡大学哲学、心理学和语言科学学院伦理委员会的批准。如果您对作为参与者的权利有任何疑问或意见，\
    可以通过 0131 650 4020 或 ppls.ethics@ed.ac.uk 与他们联系。</p>\
    <p style='text-align:left'>点击<b>“我同意”</b>按钮将代表您已知晓并同意以下内容： <br>\
    1.	<b>我同意我和我的孩子参加这项研究。</b><br>\
    2.	我确认<b>我已阅读并理解我和我孩子的数据将如何存储和使用。</b><br>\
    3.	我了解<b>在完成实验后两周内我有权要求退出研究。</b></p>\ ",
    choices: ["我同意"],
  };
  
  var instruction_screen_pre_audio_test = {
    type: "html-button-response",
    stimulus:
    "<h3>你已经完成问卷！</h3>\
    <p style='text-align:left'>感谢您的参与。 \
    在第二部分开始之前，您可能需要<b>测试设备音量</b>.</p>\
    <p style='text-align:left'>在点击“开始音量测试”之后，测试音频会自动开始播放。 \
    请调整您的设备音量，直到您和您的孩子感到合适。\
    如果您想重播测试音频，可以点击“再听一次”。</p>",
    choices: ["开始音量测试"],
  };
  
  var instruction_screen_audio_test = {
    timeline: [{
      type: "audio-button-response",
      stimulus: 'sounds/1.mp3',
      choices: ["再听一次","继续"],
  }],
    loop_function: function(data){
      if(data.values()[0].response == 0){
          return true; // loop again!
      } else {
          return false; // continue
      }
    }
  };
  
  var instruction_screen_0 = {
    type: "html-button-response",
    stimulus:
      "<p style='text-align:left'>感谢您的参与！现在开始第二部分。</p>\
    <p style='text-align:left'><b>在接下来的部分，我们需要您的孩子独立操作实验。请不要干涉您孩子的选择。</b></p>",
    choices: ["我是孩子本人，我已经准备好开始实验"],
  };
  
  var instruction_screen = {
    type: "html-button-response",
    stimulus:
      "<h3>欢迎来到第二部分！</h3>\
    <p style='text-align:left'>在第二部分，你会听到一系列短故事，每个故事都有两张图片。\
    听完故事以后，你需要点击你认为最符合故事内容的那张图片。</p>" +
    "<img src='images/example.png' width=700px></img>" +
    "<p style='text-align:left'> 点击图片下面的 " +
        "<img src='images/sound.png' width=40px></img>" + " 你可以重播<b>一次</b>故事。 </p>\
    <p style='text-align:left'>接下来你会看到三个练习例子。点击“继续”开始练习</p>",
    choices: ["继续"],
  };
  
  var instruction_screen_2 = {
    type: "html-button-response",
    stimulus:
      "<p>你已经完成所有练习！</p>\
      <p> <b>下面开始正式实验。</b></p>",
    choices: ["开始实验"],
  };
  
  var final_screen = {
    type: "html-button-response",
    stimulus:
      "<h3>恭喜完成！</h3>\
    <p style='text-align:left'><b>感谢您的参与。</b> </p>\
    <p style='text-align:left'>你的完成码是： <b>" + participant_id + "</b></p>" +
    "<p style='text-align:left'> 请复制该完成码，并回复此邮件（完成码+支付宝账号）。\
    若没有支付宝，您可以提供微信账号，我会通过微信给你转账。您将在回复邮件一周内收到参与费。 </p>\
    <p style='text-align:left'>若您有任何疑问，请联系实验人员 (Shuya Chen, s2164197@ed.ac.uk)。</p>",
    choices: ["完成"],
  };
  
  /******************************************************************************/
  /*** Reading the trial list from a CSV file ***********************************/
  /******************************************************************************/
  
  
  /*
  This function reads the trial list provided in triallist_filename (using code in a 
  separate file, read_from_csv.js), and converts it to a series of jsPsych trials. 
  We read the trial list in as a javascript array using read_trial_list (defined 
  in read_from_csv.js). Since reading the CSV file takes some time, we have to 
  use the async and await functions to ensure that the CSV file has been read before we 
  start processing it. We then use build_timeline to turn the array into a list of jsPsych 
  trials. Finally we use build_button_image_preload to build our image preload list, and 
  then add instructions etc to produce the full timeline, which we run with init.
  */
  
  async function read_trials_and_prepare_timeline(triallist_filename) {
    var trial_list = await read_trial_list(triallist_filename);
    var interaction_trials = build_timeline(trial_list);
    var exercise_trials = build_exe_trials(exe_list);
    var preload_trial = build_button_image_preload(interaction_trials);
    var interaction_trials_ran = jsPsych.randomization.shuffle(interaction_trials);
    var full_timeline = [].concat(
      consent_screen,
      dialect_background_questionnaire,
      dialect_background_questionnaire_1,
      dialect_background_questionnaire_2,
      dialect_background_questionnaire_3,
      instruction_screen_pre_audio_test,
      instruction_screen_audio_test,
      instruction_screen_0,
      instruction_screen,
      write_headers,
      exercise_trials,
      instruction_screen_2,
      preload_trial,
      interaction_trials_ran,
      final_screen
    );
    jsPsych.init({
      timeline: full_timeline,
      on_finish: function () {
        //jsPsych.data.displayData("csv"); //and also dump *all* the data to screen
      },
    });
  }
  
  
  /*
  build_timeline takes a trial list read from a CSV and uses make_picture_selection_trial
  and make_picture_description_trial to convert each row of that CSV file into a pair
  of jsPsych trials, reading the relevant info from the appropriate columns in the CSV
  data structure.
  */
  function build_timeline(trial_list) {
    var interaction_trials = [];
    for (trial of trial_list) {
      var prime_trial = make_picture_selection_trial(trial.stimulus, [
                                                     trial.matcherArray1,
                                                     trial.matcherArray2,
      ]);
      interaction_trials.push(prime_trial);
    }
    return interaction_trials;
  }
  
  /*
  build exercise trials 
  */
  function build_exe_trials(exe_list){
    var exe_trials = [];
    for (exe of exe_list) {
      var exe_trial = exercise_trial(...exe);
      exe_trials.push(exe_trial);
    }
    return exe_trials
  }
  
  /*
  This simply wraps up the code to build the preload trial into a function, so we 
  can call it once we've read in our trial list.
  */
  
  function build_button_image_preload(interaction_trials) {
    var button_images_list = [];
    for (trial of interaction_trials) {
      var trial_embedded_timeline = trial.timeline;
      for (subtrial of trial_embedded_timeline) {
        if (subtrial.type == "audio-button-response") {
          var image_choices = subtrial.choices;
          for (image of image_choices) {
            var full_image_name = "images/" + image + ".png";
            button_images_list.push(full_image_name);
          }
        }
      }
    }
  
    var preload_trial = {
      type: "preload",
      auto_preload: true,
      images: button_images_list,
    };
  
    return preload_trial;
  }
  
  
  function random_condition() {
    var available_csvs = ["listA.csv","listB.csv"];
    var selected_csv = jsPsych.randomization.shuffle(available_csvs)[0];
    return selected_csv;
  }
  
  var this_condition = random_condition();
  var list = this_condition.slice(4,5)
  var participant_id = participant_id + list
  //console.log(this_condition); //logging it so you can see it in the console
  
  read_trials_and_prepare_timeline(this_condition);
  
  