/******************************************************************************/
/*** exe trials materials*******************************************************/
/******************************************************************************/

var exe_list = [
  ["exe_1",["bird_sleep", "dog_bark"]],
  ["exe_2",["dog_run", "lion_run"]],
  ["exe_3",["rabbit_stand", "lion_sleep"]]
]


/******************************************************************************/
/*** Saving data trial by trial ***********************************************/
/******************************************************************************/

/*
This is the save_data function provided in Alisdair's tutorial, section 06. 
*/
function save_data(name, data_in) {
  var url = "save_data.php";
  var data_to_send = { filename: name, filedata: data_in };
  fetch(url, {
    method: "POST",
    body: JSON.stringify(data_to_send),
    headers: new Headers({
      "Content-Type": "application/json",
    }),
  });
}

function save_questionnaire_data(data_to_save, headers = '') {
  var line = headers + data_to_save.join(",") + ",";
  var this_participant_filename = "pvt_" + participant_id + "_questionnaire.csv";
  save_data(this_participant_filename, line);
}

/*
This is a slightly modification to Alisdair's saveDataLine code. Note that data is
save to a file named cp_ID.csv, where cp stands for confederate priming and ID is
the randomly-generated participant ID.

We have to check which trial type we are selecting data for, since picture_description 
trials lack a button_choices and button_selected entries. There's also no point 
saving the data.response info for picture_description trials, since it just indicates 
the participant clicking on the mic button, so we will save "NA" for those missing values.

For picture_selection trials, data.button_choices will be a list of 4 image names - 
here I am using .join to turn that list into a single string for writing, rather than doing 
e.g. data.button_choices[0], data.button_choices[1], data.button_choices[2], etc to
write all those choices to the CSV.
*/
function save_confederate_priming_data(data) {
  // choose the data we want to save - this will also determine the order of the columns
  if (data.participant_task == "picture_selection") {
    var button_choices_as_string = data.button_choices.join(",");
    var data_to_save = [
      participant_id,
      data.trial_index,
      data.participant_task,
      data.stimulus,
      button_choices_as_string,
      data.response,
      data.button_selected,
      data.rt,
    ];
  }
  // join these with commas and add a newline
  var line = data_to_save.join(",") + "\n";
  var this_participant_filename = "pvt_" + participant_id + ".csv";
  save_data(this_participant_filename, line);
}

/******************************************************************************/
/*** Generate a random participant ID *****************************************/
/******************************************************************************/

/*
We'll generate a random participant ID when the experiment starts, and use this
to save a seperate set of data files per participant.
*/

var participant_id = jsPsych.randomization.randomID(10);

/******************************************************************************/
/*** Flipping images ***************************************************/
/******************************************************************************/

/*
The images folder contains two versions of each image - the orientation they were
drawn in, and then a reversed image where the image is flipped on its horizontal
axis - the two images have the same name except that the reversed image has "_r"
added at the end. Since the order the characters and objects appear in a scene might
influence how people talk about them, we want to rndomise this whenever these images
appear, which is done by this random_image_flip function, which takes an image name
and either returns that image name or the reversed version, by adding "_r" to the
end of the image name.
*/
function random_image_flip(image_name) {
  var image_affixes = ["", "_r"];
  var selected_affix = jsPsych.randomization.shuffle(image_affixes)[0];
  var new_image_name = image_name + selected_affix;
  return new_image_name;
}

 
/******************************************************************************/
/*** Dialect background questionnaire *********************************************/
/******************************************************************************/

var likert_scale_2 = [
  "almost never/never",
  "at least once a week",
  "everyday"  
];

var dialect_background_questionnaire = {
  type: "survey-html-form",
  preamble:
    "<p style='text-align:left'> <h3>Language Background Questionnaire</h3></p>\
              <p style='text-align:left'> <b>In this questionnaire we would like to \
              gather information about the language backgroud of your child. The questionnaire includes two sets (A and B) of questions.\
              It might cost you 3 minutes to finish. </b></p>" ,
  html: "<p style='text-align:left'>A1. What's the age of your child? <br> \
              Age: <input min=4 max= 15 required name='year' type='number'>\
              Month: <input min=1 max= 12 required name='month' type='number'></p> \
         <p style='text-align:left'>A2. What's the gender of your child? <br> \
              <input required type='radio' name='gender' value='Male'>Male<br>\
              <input required type='radio' name='gender' value='Female'>Female<br>\
              <input required type='radio' name='gender' value='Other'>Other<br>\
         <p style='text-align:left'>A3. Does your child speak any language(s) other than English and Mandarin Chinese? \
         If so, please type in the other langauge(s) your child speak. If no, please enter 'No' and skip the question A3.1. <br> \
              <input required name='language' type='text'></p>\
         <p style='text-align:left'>A3.1. Where does your child receive exposure of <b>the other language?</b> <br> \
              <input type='radio' name='exposure' value='family'>He/she speaks (or listen) the language to one of the parents or other family members more than once a week.<br>\
              <input type='radio' name='exposure' value='school'>He/she resgitered in a bilingual/multilingual preschool or school.<br>\
              <input type='radio' name='exposure' value='both'>Both of them<br>\
              <input type='radio' name='exposure' value='other'> Others:\
              <input name='other_exposure' type='text' size='100'></p>",
  on_finish: function (data) {
    var questionnaire_data = data.response;
    var data_to_save = [
      participant_id,
      questionnaire_data.year,
      questionnaire_data.month,
      questionnaire_data.gender,
      questionnaire_data.language,
      questionnaire_data.exposure,
      questionnaire_data.other_exposure
    ];
    var headers = "id,A1_age_year,A1_age_month,A2_gender,A3_language, A4_exposure, A3_1_other_exposure,\
    B1_current_school, B1_current_grade, B2_exposure_school,\
    C1_E_reading, C1_E_digital, C1_E_internet, C1_E_phone, C1_E_Skype, C1_E_movie, C1_E_music,\
    C2_M_reading, C2_M_digital, C2_M_internet, C2_M_phone, C2_M_Skype, C2_M_movie, C2_M_music\n";
    save_questionnaire_data(data_to_save,headers);
  },
};


var dialect_background_questionnaire_1 = {
  type: "survey-html-form",
  html: "<p style='text-align:left'>B1. What school and grade does your child currently attend? <br> \
              <input required type='radio' name='school' value='primary'>Primary school<br>\
              <input required type='radio' name='school' value='secondary'>Secondary school<br>\
              Grade: Year <input required min=1 max= 6 name='grade' type='number'> <br>\
         <p style='text-align:left'>B2. How much English does your child receive at school?<br> \
              <input required type='radio' name='program' value='4'>He/she is registered in a program where 100% of school is in English <br>\
              <input required type='radio' name='program' value='3'>He/she is registered in a bilingual program at school<br>\
              <input required type='radio' name='program' value='2'>He/she only receives formal instruction in English classes in school <br>\
              <input required type='radio' name='program' value='1'>He/she receives little or no formal instruction in  his/her English in school, but attends English classes outside of school.<br>\
              <input required type='radio' name='program' value='0'>He/she receives little or no formal instruction in his/her English.<br>",
  on_finish: function (data) {
    var questionnaire_data = data.response;
    var data_to_save = [
      questionnaire_data.school,
      questionnaire_data.grade,
      questionnaire_data.program,
    ];
    save_questionnaire_data(data_to_save);
  },
};

var dialect_background_questionnaire_2 = {
  type: "survey-likert",
  preamble: "C1. What literacy and other extra-curricular language activities <b>in English</b> does your child do each week?",
  questions: [
    {prompt: "Reads books or magazines", name: 'extra_E_read', labels: likert_scale_2, required: true},
    {prompt: "Digital Language Learning (Rosetta Stone, Duolingo, etc)", name: 'extra_E_digital', labels: likert_scale_2, required: true},
    {prompt: "Uses Internet (Facebook, Twitter, snapchat, Instagram, e-mail, etc)", name: 'extra_E_internet', labels: likert_scale_2, required: true},
    {prompt: "Cellphone (calling and texting)", name: 'extra_E_phone', labels: likert_scale_2, required: true},
    {prompt: "Online video", name: 'extra_E_skype', labels: likert_scale_2,required: true},
    {prompt: "Movies/TV Shows", name: 'extra_E_movie', labels: likert_scale_2,required: true},
    {prompt: "Music", name: 'extra_E_music', labels: likert_scale_2,required: true},
  ],
  on_finish: function (data) {
    var questionnaire_data = data.response;
    var data_to_save = [
      questionnaire_data.extra_E_read,
      questionnaire_data.extra_E_digital,
      questionnaire_data.extra_E_internet,
      questionnaire_data.extra_E_phone,
      questionnaire_data.extra_E_skype,
      questionnaire_data.extra_E_movie,
      questionnaire_data.extra_E_music,
    ];
    save_questionnaire_data(data_to_save);
  },
};

var dialect_background_questionnaire_3 = {
  type: "survey-likert",
  preamble: "C2. What literacy and other extra-curricular language activities <b>in Mandarin</b> does your child do each week?",
  questions: [
    {prompt: "Reads books or magazines", name: 'extra_M_read', labels: likert_scale_2,required: true},
    {prompt: "Digital Language Learning (Rosetta Stone, Duolingo, etc)", name: 'extra_M_digital', labels: likert_scale_2,required: true},
    {prompt: "Uses Internet (Facebook, Twitter, snapchat, Instagram, e-mail, etc)", name: 'extra_M_internet', labels: likert_scale_2,required: true},
    {prompt: "Cellphone (calling and texting)", name: 'extra_M_phone', labels: likert_scale_2,required: true},
    {prompt: "Online video", name: 'extra_M_skype', labels: likert_scale_2,required: true},
    {prompt: "Movies/TV Shows", name: 'extra_M_movie', labels: likert_scale_2,required: true},
    {prompt: "Music", name: 'extra_M_music', labels: likert_scale_2,required: true},
  ],
  on_finish: function (data) {
    var questionnaire_data = data.response;
    var data_to_save = [
      questionnaire_data.extra_M_read,
      questionnaire_data.extra_M_digital,
      questionnaire_data.extra_M_internet,
      questionnaire_data.extra_M_phone,
      questionnaire_data.extra_M_skype,
      questionnaire_data.extra_M_movie,
      questionnaire_data.extra_M_music,
    ];
    save_questionnaire_data(data_to_save);
  },
};

/******************************************************************************/
/*** Picture selection trials *************************************************/
/******************************************************************************/

function make_picture_selection_trial(sound, images) {
  var sound_file = "sounds/" + sound + ".mp3";
  var image_choices = [];
  for (image of images) {
    image_choices.push(random_image_flip(image));
    var image_choices = jsPsych.randomization.shuffle(image_choices)
    //console.log(image_choices)
  }

  //audio trial
  var selection_trial = {
    type: "audio-button-response",
    stimulus: sound_file,
    choices: image_choices,
    button_html:
      ['<button class="jspsych-btn" style = "position:sticky; left:180px; top: 150px"> <img src="images/%choice%.png" width=500px></button>',
      '<button class="jspsych-btn" style = "position:sticky; right:180px; top: 150px"> <img src="images/%choice%.png" width=500px></button>',
      '<button class="jspsych-btn" style = "position:absolute; left:670px; top: 600px"> <img src="images/%choice%.png" width=45px></button>'],
    //response_allowed_while_playing: false, //participant can't make choices before the audio finishes playing
    post_trial_gap: 500, //a little pause after the participant makes their choice
    on_start: function (trial) {
      var shuffled_image_choices = trial.choices;
      var shuffled_image_choices_mic = [...shuffled_image_choices,"sound"];
      trial.choices = shuffled_image_choices_mic;
      trial.data = {
        participant_task: "picture_selection",
        button_choices: shuffled_image_choices_mic,
      };
    },
    on_finish: function (data) {
      var button_number = data.response;
      data.button_selected = data.button_choices[button_number];
      save_confederate_priming_data(data); //save the trial data
    },
  };

  var selection_trial_2 = {
    type: "audio-button-response",
    stimulus: sound_file,
    choices: image_choices,
    button_html:
      ['<button class="jspsych-btn" style = "position:sticky; left:180px; top: 150px"> <img src="images/%choice%.png" width=500px></button>',
      '<button class="jspsych-btn" style = "position:sticky; right:180px; top: 150px"> <img src="images/%choice%.png" width=500px></button>'],
    //response_allowed_while_playing: false, //participant can't make choices before the audio finishes playing
    post_trial_gap: 500, //a little pause after the participant makes their choice
    on_start: function (trial) {
      var shuffled_image_choices = trial.choices;
      trial.data = {
        participant_task: "picture_selection",
        button_choices: shuffled_image_choices,
      };
    },
    on_finish: function (data) {
      var button_number = data.response;
      data.button_selected = data.button_choices[button_number];
      save_confederate_priming_data(data); //save the trial data
    },
  };
  
  var if_node = {
    timeline: [selection_trial_2],
    conditional_function: function(){
        // get the data from the previous trial,
        // and check which key was pressed
        var data = jsPsych.data.get().last(1).values()[0];
        //console.log(data.response);
        if(data.response == 2){
            return true;
        } else {
            return false;
        }
    }
};

  var full_trial = { timeline: [selection_trial, if_node]
   };
  return full_trial;
}

/******************************************************************************/
/*** Write headers for data file **********************************************/
/******************************************************************************/

/*
Same as the perceptual learning practical.
*/
var write_headers = {
  type: "call-function",
  func: function () {
    var this_participant_filename = "pvt_" + participant_id + ".csv";
    save_data(
      this_participant_filename,
      "participant_id,trial_index,participant_task,stimulus,button_choice0,button_choice1, button_choice3,response,button_selected,rt\n"
    );
  },
};

/******************************************************************************/
/*** Instruction trials *******************************************************/
/******************************************************************************/

/*
As usual, your experiment will need some instruction screens.
*/

var consent_screen = {
  type: "html-button-response",
  stimulus:
    "<h3>Welcome to the experiment</h3> \
  <p style='text-align:left'><b>Project title</b>: Sentence comprehension study <br>\
  <b>Principal Investigator</b>: Dr Vicky Chondrogianni <br>\
  <b>Researcher collecting data</b>: Shuya Chen</p> \
  <p style='text-align:left'><b>Invitation to participate.</b> \
  You and your child are invited to participate in a research study on how children comprehend sentences. \
   This document explains our study, what your rights are, \
   and what will be done with the data we collect. \
   You should keep this page for your records.</p>\
  <p style='text-align:left'> <b>What is the study about?</b> \
  The two languages of a bilingual child have been argued to interact with each other. \
  The aim of the study is to explore how English-Mandarin bilingual children comprehend \
  sentences in Mandarin. To better understand your child’s language development, \
  we will also ask you some questions about your child’s pattern of language use. </p>\
  <p style='text-align:left'><b>What will happen?</b> If you and your child agree to participate,\
   we will ask your child to listen to short stories and click on the picture that they think matches the story. \
   Their responses will be recorded. Before you started, we may have also some questions about your child’s experience\
    (e.g., age, gender, language background). The experiment will last up to 60 minutes. \
    We will confirm your child’s assent before we begin the study, and we will monitor for \
    verbal/non-verbal signals that they no longer wish to participate, in which case we will end the study.</p>\
  <p style='text-align:left'><b>Compensation.</b> You will be paid ____£8___for your participation in this study.</p>\
  <p style='text-align:left'><b>Risks and benefits.</b>\
   There are no known risks to participation in this study. \
   There are no tangible benefits to you or your child, however, \
   you will be making a contribution to our knowledge about language and how it is learned.</p>\
  <p style='text-align:left'><b>Confidentiality and use of data.</b> \
  All the information we collect during the course of the research will be processed in accordance \
  with Data Protection Law. In order to safeguard your own and your child’s privacy, we will only \
  collect your email address for payment processing, and we will delete your emails after the payment\
   is processed. We will not collect any other personal information. You and your child's data will be \
   only referred to by a unique participant number. The anonymised data collected during this study will \
   be used for research purposes and may be shared with other researchers.</p>\
  <p style='text-align:left'><b>What are my data protection rights?</b> The University of Edinburgh is a Data \
  Controller for the information you provide.  You have the right to access information held about you. \
  Your right of access can be exercised in accordance with Data Protection Law. You also have other rights \
  including rights of correction, erasure and objection.  For more details, including the right to lodge a \
  complaint with the Information Commissioner’s Office, please visit www.ico.org.uk.  Questions, comments and \
  requests about your personal data can also be sent to the University Data Protection Officer at dpo@ed.ac.uk.</p>\
  <p style='text-align:left'><b>Voluntary participation and right to withdraw.</b> We will ask you and your child’s permission \
  before we begin the study, and we will make sure you and they understand that they can stop the study at any point. \
  You may also choose to withdraw your child from the study until two weeks after participating in the study. Any data \
  supplied up to that point will be deleted. Please note that if you decide to withdraw after the specified date, we may \
  not be able to delete your anonymised data from e.g. public repositories of research data, but we will be able to delete \
  all of your personal data from our records.</p>\
  <p style='text-align:left'>If you have any questions about what you’ve just read, please feel free to ask, or contact us later. \
  You can contact us by email at s2164197@ed.ac.uk. This project has been approved by the PPLS Ethics committee. \
  If you have questions or comments regarding your own or your child’s rights as a participant, they can be contacted at \
  0131 650 4020 or ppls.ethics@ed.ac.uk.</p>\
  <p style='text-align:left'>By clicking on <b>‘I agree’</b>, you consent to the following: <br>\
  1.	<b>I consent to myself and my child taking part in the above study.</b><br>\
  2.	I confirm that I have read and understood <b>how my data and my child’s data will be stored and used.</b><br>\
  3.	I understand that I have the <b>right to terminate this session</b> until two weeks after participating in the study. \
  If I choose to <b>withdraw after completing the study</b>, my data will be deleted at that time.</p>\ ",
  choices: ["I agree"],
};

var instruction_screen_pre_audio_test = {
  type: "html-button-response",
  stimulus:
  "<h3>You have finished the questionnaire!</h3>\
  <p style='text-align:left'>Thank you for your participation. \
  Before we move on to the main experiment, you may need to <b>test your device volume</b>.</p>\
  <p style='text-align:left'>Once you click on 'start audio testing', the audio will start automatically. \
  Please adjust the volume of your computer/laptop untill you and your child find it comfortable.\
  You can replay the audio by pressing the 'play again' button.</p>",
  choices: ["start audio testing"],
};

var instruction_screen_audio_test = {
  timeline: [{
    type: "audio-button-response",
    stimulus: 'sounds/1.mp3',
    choices: ["Play again","Continue"],
}],
  loop_function: function(data){
    if(data.values()[0].response == 0){
        return true; // loop again!
    } else {
        return false; // continue
    }
  }
};

var instruction_screen_0 = {
  type: "html-button-response",
  stimulus:
    "<p style='text-align:left'>Thank you for your participation. Now we can move on to the main experiment!</p>\
  <p style='text-align:left'><b>In the following sections, we will need your child to take over the experiment and complete it independently.\
  Please do not interfere with your child's judgements.</b></p>",
  choices: ["I am the child and I'm in control"],
};

var instruction_screen = {
  type: "html-button-response",
  stimulus:
    "<h3>Welcome to the main experiment!</h3>\
  <p style='text-align:left'>In the main experiment, you will listen to a set of short stories.\
      With each story, two pictures will be shown on the screen. After listening to the story, \
      you will need to click on the picture that you think best matches the sentence.</p>" +
  "<img src='images/example.png' width=700px></img>" +
  "<p style='text-align:left'> You can reply the story <b>once</b> by clicking the " +
      "<img src='images/sound.png' width=40px></img>" + " button below the two pictures. </p>\
  <p style='text-align:left'>You will see three examples in the following section. \
      Click on the 'Continue' button to move on to the examples.</p>",
  choices: ["Continue"],
};

var instruction_screen_2 = {
  type: "html-button-response",
  stimulus:
    "<p>You have finished all the exercise!</p>\
    <p> <b>Now let's move on to the main experiment</b></p>",
  choices: ["Start the main experiment"],
};


var final_screen = {
  type: "html-button-response",
  stimulus:
    "<h3>Finished!</h3>\
  <p style='text-align:left'><b>Thank you so much for your participation!</b> </p>\
  <p style='text-align:left'>Your completion code is: <b>" + participant_id + "</b></p>" +
  "<p style='text-align:left'> You can now fill your completion code in the payment claiming form. \
  You can find the link of the payment claiming form in the email we send you, below the link of this experiment.\
  You will receive your payment within a week after you claim your payment. </p>\
  <p style='text-align:left'>If you have any further question, please contact the experimenter (Shuya Chen, s2164197@ed.ac.uk).</p>",
  choices: ["Finish"],
};

/******************************************************************************/
/*** Reading the trial list from a CSV file ***********************************/
/******************************************************************************/


/*
This function reads the trial list provided in triallist_filename (using code in a 
separate file, read_from_csv.js), and converts it to a series of jsPsych trials. 
We read the trial list in as a javascript array using read_trial_list (defined 
in read_from_csv.js). Since reading the CSV file takes some time, we have to 
use the async and await functions to ensure that the CSV file has been read before we 
start processing it. We then use build_timeline to turn the array into a list of jsPsych 
trials. Finally we use build_button_image_preload to build our image preload list, and 
then add instructions etc to produce the full timeline, which we run with init.
*/

async function read_trials_and_prepare_timeline(triallist_filename) {
  var trial_list = await read_trial_list(triallist_filename);
  var interaction_trials = build_timeline(trial_list);
  var exercise_trials = build_exe_trials(exe_list);
  var preload_trial = build_button_image_preload(interaction_trials);
  var interaction_trials_ran = jsPsych.randomization.shuffle(interaction_trials);
  var full_timeline = [].concat(
    consent_screen,
    dialect_background_questionnaire,
    dialect_background_questionnaire_1,
    dialect_background_questionnaire_2,
    dialect_background_questionnaire_3,
    instruction_screen_pre_audio_test,
    instruction_screen_audio_test,
    instruction_screen_0,
    instruction_screen,
    write_headers,
    exercise_trials,
    instruction_screen_2,
    preload_trial,
    interaction_trials_ran,
    final_screen
  );
  jsPsych.init({
    timeline: full_timeline,
    on_finish: function () {
      //jsPsych.data.displayData("csv"); //and also dump *all* the data to screen
    },
  });
}


/*
build_timeline takes a trial list read from a CSV and uses make_picture_selection_trial
and make_picture_description_trial to convert each row of that CSV file into a pair
of jsPsych trials, reading the relevant info from the appropriate columns in the CSV
data structure.
*/
function build_timeline(trial_list) {
  var interaction_trials = [];
  for (trial of trial_list) {
    var prime_trial = make_picture_selection_trial(trial.stimulus, [
                                                   trial.matcherArray1,
                                                   trial.matcherArray2,
    ]);
    interaction_trials.push(prime_trial);
  }
  return interaction_trials;
}

/*
build exercise trials 
*/
function build_exe_trials(exe_list){
  var exe_trials = [];
  for (exe of exe_list) {
    var exe_trial = make_picture_selection_trial(...exe);
    exe_trials.push(exe_trial);
  }
  return exe_trials
}

/*
This simply wraps up the code to build the preload trial into a function, so we 
can call it once we've read in our trial list.
*/

function build_button_image_preload(interaction_trials) {
  var button_images_list = [];
  for (trial of interaction_trials) {
    var trial_embedded_timeline = trial.timeline;
    for (subtrial of trial_embedded_timeline) {
      if (subtrial.type == "audio-button-response") {
        var image_choices = subtrial.choices;
        for (image of image_choices) {
          var full_image_name = "images/" + image + ".png";
          button_images_list.push(full_image_name);
        }
      }
    }
  }

  var preload_trial = {
    type: "preload",
    auto_preload: true,
    images: button_images_list,
  };

  return preload_trial;
}


function random_condition() {
  var available_csvs = ["listA.csv","listB.csv"];
  var selected_csv = jsPsych.randomization.shuffle(available_csvs)[0];
  return selected_csv;
}

var this_condition = random_condition();
//console.log(this_condition); //logging it so you can see it in the console

read_trials_and_prepare_timeline(this_condition);

