/******************************************************************************/
/*** Preamble *****************************************************************/
/******************************************************************************/

/*
This is a simple offline judgement test. 

Participants read a sentence and answer a comprehensive question about the sentence.

The question is shown in a multi-choice way. The order of the questions and the options 
are auto-randomized.

There are four conditions in the experiment, which means there are four lists. 
Participants are randomly assigned to the four list. 


/******************************************************************************/
/*** Initialise jspsych *******************************************************/
/******************************************************************************/

/*
The progress bar is defined here.
*/

var jsPsych = initJsPsych({
  show_progress_bar: true,
  message_progress_bar: '',
  default_iti: 200,
  on_finish: function () {
    //jsPsych.data.displayData("csv"); //dump the data to screen
  },
});



/******************************************************************************/
/*** Saving data trial by trial ***********************************************/
/******************************************************************************/

/*
This is the save_data function provided in Alisdair's tutorial, section 06. 
*/
function save_data(name, data_in) {
  var url = "save_data.php";
  var data_to_send = { filename: name, filedata: data_in };
  fetch(url, {
    method: "POST",
    body: JSON.stringify(data_to_send),
    headers: new Headers({
      "Content-Type": "application/json",
    }),
  });
}

function save_pronoun_production_data(data) {
  // choose the data we want to save - this will also determine the order of the columns
  if (data.participant_task == "pronoun_production") {
    var data_to_save = [
      participant_id,
      data.trial_index,
      data.participant_task,
      data.ori_index,
      data.type,
      data.verb,
      data.bias,
      data.list,
      data.NP1,
      data.NP2,
      data.sentence,
      data.response.response,
      data.rt,
    ];
  } 
  // join these with commas and add a newline
  var line = data_to_save.join(",") + "\n";
  var this_participant_filename = "pp_" + participant_id + ".csv";
  save_data(this_participant_filename, line);
}


function save_comprehension_data(data) {
  // choose the data we want to save - this will also determine the order of the columns
  if (data.participant_task == "comprehension") {
    var data_to_save = [
      participant_id,
      data.trial_index,
      data.participant_task,
      data.ori_index,
      data.sentence,
      data.question,
      data.answer,
      data.response,
      data.rt,
    ];
  } 
  // join these with commas and add a newline
  var line = data_to_save.join(",") + "\n";
  var this_participant_filename = "com_" + participant_id + ".csv";
  save_data(this_participant_filename, line);
}
/******************************************************************************/
/*** Generate a random participant ID *****************************************/
/******************************************************************************/

/*
We'll generate a random participant ID when the experiment starts, and use this
to save a seperate set of data files per participant.
*/

var participant_id = jsPsych.randomization.randomID(10);


/******************************************************************************/
/*** pronoun production trials *************************************************/
/******************************************************************************/


function make_pronoun_production_trial(ori_index,type,verb,bias,list,NP1,NP2,sentence,question,answer){
  var selection_trial = {
    type: jsPsychSurveyHtmlForm,
    html: '<p>' + sentence + '<input type="text" id="test-resp-box" name="response" required size="40" /> </p>', 
    button_label: '继续',
    autofocus: 'test-resp-box',
    on_start: function (trial) {
      trial.data = {
        participant_task: "pronoun_production",
        ori_index: ori_index,
        type: type, 
        verb: verb,
        bias: bias,
        list: list,
        NP1: NP1,
        NP2: NP2,
        sentence: sentence,
      };
    },
    on_finish: function (data) {
      //var res = data.response.response;
      //console.log(res);
      save_pronoun_production_data(data); //save the trial data
    },
  }

  var comprehension_trial = {
    type: jsPsychHtmlButtonResponse,
    stimulus: question,
    choices: ['是', '否'],
    prompt: '上面的信息符合上一个句子的内容吗？',
    on_start: function (trial) {
      trial.data = {
        participant_task: "comprehension",
        ori_index: ori_index,
        sentence: sentence,
        question: question,
        answer: answer
      };
    },
    on_finish:function (data) {
      save_comprehension_data(data);
    }
  }

  var full_trial = {timeline: []};

  if (question == 'skip'){
    full_trial = {timeline: [selection_trial]};
  } else {
    full_trial = {timeline: [selection_trial, comprehension_trial]};
  }

  return full_trial;
}




/******************************************************************************/
/*** Exercise trials *************************************************/
/******************************************************************************/

var exercise_list = [
  {target: '小明昨天终于见到了小强，然而', question: 'skip'},
  {target: '今天小美给玲玲过生日，可是', question: 'skip'},
  {target: '王总在办公室没有见到小张，难道', question: '王总没有去办公室。'}
];


function make_exercise_trial(target, question) {

  var exercise_trial = {
    type: jsPsychSurveyHtmlForm,
    preamble: "<p style='color:red'> <i> *** 这些短句会包含<b>「两个人物」</b>之间的互动。***</i></p>\
             <p style='color:red'> <i>***补全句子时，请用<b>「其中一个人物」</b>为句子提供可能的后续。*** </i></p>\
             <p style='color:red''> <i>***完成补全后，点击<b>「继续」</b> 或敲击<b>「回车」</b>键，您将会跳到下一题。***</i></p>",
    html: '<p>' + target + '<input type="text" required id="test-resp-box" name="response" size="40" /> </p>', 
    autofocus: 'test-resp-box',
    button_label: '继续',
  };


  var exercise_trial2 = {
    type: jsPsychHtmlButtonResponse,
    stimulus: "<p style='color:red'> <i> *** 在完成句子以后，您有时会需要回答一个关于该句子的 <b>判断题 </b> 。***</i></p>\
    <p style='color:red'> <i> ***如果你认为上面的信息符合刚才的句子，请点击「是」，否则，点击「否」。***</i></p>" 
    + question,
    choices: ['是', '否'],
    prompt: '上面的信息符合上一个句子的内容吗？',
  }

  var full_trial = {timeline: []};

  if (question == 'skip'){
    full_trial = {timeline: [exercise_trial]};
  } else {
    full_trial = {timeline: [exercise_trial, exercise_trial2]};
  }


  return full_trial;
}

/******************************************************************************/
/*** Example trials *************************************************/
/******************************************************************************/



var example_trial = {
    type: jsPsychSurveyHtmlForm,
    preamble:"<p style='color:red'> <i> *** 这些短句会包含<b>「两个人物」</b>之间的互动。***</i></p>\
             <p style='color:red'> <i>***补全句子时，请用<b>「其中一个人物」</b>为句子提供可能的后续。*** </i></p>\
             <p style='color:red'> <i>***完成补全后，点击<b>「继续」</b> 或敲击<b>「回车」</b>键，您将会跳到下一题。***</i></p>\
             <p style='color:blue'>示例回答一：小明没有出现。</p>\
             <p style='color:blue'>示例回答二：他没有出现。</p>\
             <p style='color:blue'>示例回答三：小丽没有出现。</p>\
             <p style='color:blue'>示例回答四：她没有出现。</p>\
             ",
    html: '<p>' + '小明要和小美一起开会，但是' + '<input type="text" id="test-resp-box" name="response" size="40"> </p>', 
    button_label: '继续',
  };

var example_trial2 = {
    type: jsPsychSurveyHtmlForm,
    preamble:"<p style='color:red'> <i> *** 这些短句会包含<b>「两个人物」</b>之间的互动。***</i></p>\
             <p style='color:red'> <i>***补全句子时，请用<b>「其中一个人物」</b>为句子提供可能的后续。*** </i></p>\
             <p style='color:red'> <i>***完成补全后，点击<b>「继续」</b> 或敲击<b>「回车」</b>键，您将会跳到下一题。***</i></p>\
             <p style='color:blue'>示例回答一：小强每天都能吃上蛋糕。</p>\
             <p style='color:blue'>示例回答二：他每天都能吃上蛋糕。</p>\
             <p style='color:blue'>示例回答三：丽丽每天都能吃上蛋糕。</p>\
             <p style='color:blue'>示例回答四：她每天都能吃上蛋糕。</p>\
             ",
    html: '<p>' + '小强教会了丽丽做蛋糕，所以' + '<input type="text" id="test-resp-box" name="response" size="40"> </p>', 
    button_label: '继续',
  };

var example_trial3 = {
    type: jsPsychHtmlButtonResponse,
    stimulus: "<p style='color:red'> <i> *** 在完成句子以后，您有时会需要回答一个关于该句子的 <b>判断题 </b> 。***</i></p>\
    <p style='color:blue'> <i> ***如果你认为上面的信息符合刚才的句子「小强教会了丽丽做蛋糕」， 请点击「是」，否则，点击「否」。***</i></p>" 
    + '丽丽学会了做蛋糕。',
    choices: ['是', '否'],
    prompt: '上面的信息符合上一个句子的内容吗？',
  }


var example_trials = {timeline: [example_trial, example_trial2, example_trial3]};




/******************************************************************************/
/*** Rest block *************************************************/
/******************************************************************************/

function make_rest_block (video, sec_number){
  var rest_block = {
    type: jsPsychVideoButtonResponse,
    stimulus: [video],
    choices: [],
    prompt: "<p> 现在我们可以休息一下。</p>",
    autoplay: true,
    trial_duration: 12000,
    width: '525px',
  };

  var after_rest = {
    type: jsPsychHtmlButtonResponse,
    stimulus: "<h3>现在我们继续吧！</h3>\
    <p> 你还有 " + sec_number + " 个部分需要完成 </p>",
    choices: ['继续']
  }

  var repeat_instruction = {
    type: jsPsychHtmlButtonResponse,
    stimulus: "<p style='color:red'> <i>***补全句子时，请用<b>「其中一个人物」</b>为句子提供可能的后续。*** </i></p>",
    choices: ['继续']
  }

  var full_trial = {timeline: [rest_block, after_rest, repeat_instruction]};

  return full_trial
}

/******************************************************************************/
/*** Write headers for data file **********************************************/
/******************************************************************************/


var write_pp_headers = {
  type: jsPsychCallFunction,
  func: function () {
    var this_participant_filename = "pp_" + participant_id + ".csv";
    save_data(
      this_participant_filename,
      "participant_id,trial_index,participant_task,ori_index,type,verb,bias,\
      list, NP1, NP2, sentence,response, rt\n"
    );
  },
};

var write_com_headers = {
  type: jsPsychCallFunction,
  func: function () {
    var this_participant_filename = "com_" + participant_id + ".csv";
    save_data(
      this_participant_filename,
      "participant_id,trial_index,participant_task,ori_index,sentence,question,answer,response,rt\n"
    );
  },
};

/******************************************************************************/
/*** info screens *******************************************************/
/******************************************************************************/



var pre_consent_sreen = {
  type: jsPsychHtmlButtonResponse,
  stimulus:
    " <h3>欢迎参与我们的实验！</h3> \
    <p style='text-align:left'>在开始之前，我们需要先寻求您的同意。 </p>\
    <p style='text-align:left'>您会了解参与这项实验的风险、收益、参与费，您退出实验的权利以及我们使用和保护您的数据的方式。</p>\
    <p style='text-align:left'>在正式同意以后，您会收到实验的详细指导和参与费申报的注意事项。 </p>\
    <p style='text-align:left'> 点击’继续‘跳到知情同意页。 </p>",
  choices: ["继续"],
};


var consent_screen = {
  type: jsPsychHtmlButtonResponse,
  stimulus:
  "<h3> 知情同意书 </h3> \
  <p style='text-align:left'><b>项目标题</b>：句子补全实验 <br>\
  <b>指导老师</b>：Dr Vicky Chondrogianni; Dr Patrick Sturt <br>\
  <b>研究员</b>：Shuya Chen</p> \
  <p style='text-align:left'><b>关于本实验：</b> \
  本实验将探讨人类理解与组织语句的方式。您在本实验中的回答均会被收集和记录。本实验最多持续<b>「30分钟」</b>。在下一页，您会看到详细的实验指导。</p>\
  <p style='text-align:left'><b>参与费：</b> 参与本实验以后，您会获得<b>「20元」</b>作为补贴。 </p>\
  <p style='text-align:left'><b>自愿参与及退出：</b> \
   在开始实验之前，我们会寻求您的同意，并确保您可以随时停止本实验。\
   在实验完成的两周以内，您可以选择退出本项目，我们会删除所有收集到的有关数据。\
   请注意，在截止日期以后，我们可能无法从公共信息库等地方删除您的匿名数据，但我们可以从我们的数据源中删除您的个人数据。</p>\
  <p style='text-align:left'><b>风险与收益：</b>\
    参与本实验并不会对您造成已知风险，也不会有确凿收益。然而，您会为汉语普通话的研究做出贡献。</p>\
  <p style='text-align:left'><b>数据使用和保密：</b> \
   在本实验中，我们收集到的所有数据都会根据数据保护法进行处理。为了保护您的隐私，我们只会收集您的联系方式（电子邮箱或微信号）用于支付参与费，并在支付后删除该联系方式。\
   除此以外，我们不会收集其他的个人信息。你的数据将会被匿名处理，这些匿名数据会用于我们的研究，且可能会被分享给其他研究者。</p>\
  <p style='text-align:left'><b>数据保护权利：</b> \
  爱丁堡大学是您提供信息的数据控制者。您有权通过数据保护法获取与您相关的信息。除此以外，您也有权修正、删除以及反对您的相关信息。\
  如要查询更多信息，包括向信息委员会投诉在内，请访问visit www.ico.org.uk。如有对您个人信息的疑问、评论以及请求，您也可以通过dpo@ed.ac.uk联系爱丁堡大学数据保护办公室。</p>\
  <p style='text-align:left'>如果您对上述内容有任何问题，请尽管联系我们「Shuya Chen, s2164197@ed.ac.uk」。\
  本项目已通过爱丁堡大学哲学、心理学与语言科学学院学术伦理委员会的批准。如果您有任何关于参与者权利的问题，请联系 0131 650 4020 或 ppls.ethics@ed.ac.uk. </p>\
  <p style='text-align:left'>点击<b>我同意</b>, 您将知情同意以下内容: <br>\
  1.	<b>我同意参与此项实验。</b><br>\
  2.	我确定我已经读过并了解<b>我的数据将会被如何存储和使用。</b><br>\
  3.	我了解在参与实验的两周内，我有权<b>退出本研究</b>。如果我选择<b>退出本研究</b>，我的数据将会被删除。</p>\ ",
  choices: ["我同意"],
  margin_vertical: '24px'
};

/******************************************************************************/
/*** instructions *******************************************************/
/******************************************************************************/

var instruction_screen_prepractise_1 = {
  type: jsPsychHtmlButtonResponse,
  stimulus:
    "<p style='text-align:left; color:red'> <i> <b> 请认真阅读实验指导 </b> </i> </p>\
  <p style='text-align:left'>在正式实验中，您将会看到一些<b>「不完整的中文短句」</b>。</p>\
  <p style='text-align:left'>您需要根据自己的理解<b>「补全该句子」</b>。</p>",
  choices: ["继续"],
};

var instruction_screen_prepractise_2 = {
  type: jsPsychHtmlButtonResponse,
  stimulus:
    "<p style='text-align:left; color:red'> <i> <b> 请认真阅读实验指导 </b> </i> </p>\
  <p style='text-align:left'> 这些短句会包含<b>「两个人物」</b>之间的互动。 </p>\
  <p style='text-align:left'> 补全句子时，请用<b>「其中一个人物」</b>为句子提供可能的后续。 </p>\
  <p style='text-align:left'> 完成补全后，点击<b>「继续」</b>或敲击<b>「回车」</b> 键，您将会跳到下一题。</b></p>" ,
  choices: ["继续"],
};

var instruction_screen_prepractise_3 = {
  type: jsPsychHtmlButtonResponse,
  stimulus:
    "<p style='text-align:left; color:red'> <i> <b> 请认真阅读实验指导 </b> </i> </p>\
  <p style='text-align:left'> 本实验将花费您<b>「不超过三十分钟」</b>的时间。</p> \
  <p style='text-align:left'> 在实验过程中，您将会有几次<b>「短暂休息」</b>的机会。</p>\
  <p style='text-align:left'> 您可以通过屏幕上方的<b>「进度条」</b>了解实验进度。</p>" ,
  choices: ["继续"],
};

var instruction_screen_prepractise_4 = {
  type: jsPsychHtmlButtonResponse,
  stimulus:
    "<p style='text-align:left; color:red'> <i> <b> 请认真阅读实验指导 </b> </i> </p>\
  <p style='text-align:left'> 完成实验后，您会看到一个<b>「完成码」</b>。 </p>\
  <p style='text-align:left'> 请将您的完成码保存下来，以用于<b>「参与费申报」</b>。 </p>" ,
  choices: ["继续"],
};

var instruction_screen_prepractise_5 = {
  type: jsPsychHtmlButtonResponse,
  stimulus:
    "<p style='text-align:left'> <b> 我们先看一些例子吧！ </b> </p>\
  <p style='text-align:left'> 在下个部分，你会看到两个例子。</p>" ,
  choices: ["继续"],
};


var instruction_screen_prepractise = [
  instruction_screen_prepractise_1,
  instruction_screen_prepractise_2,
  instruction_screen_prepractise_3,
  instruction_screen_prepractise_4,
  instruction_screen_prepractise_5
]

var instruction_screen_btwpractise = {
  type: jsPsychHtmlButtonResponse,
  stimulus:
    "<p> <b> 现在我们稍微练习一下吧！</b> </p>\
  <p style='text-align:left'> 练习中有三道题目。</p>\
  <p style='text-align:left'> 点击「继续」开始练习。</p>" ,
  choices: ["继续"],
};


/******************************************************************************/
/*** post practise *******************************************************/
/******************************************************************************/


var instruction_screen_postpractise = {
  type: jsPsychHtmlButtonResponse,
  stimulus:
    "<p>恭喜你完成了全部练习！</p>\
    <p> <b>现在我们开始正式实验。</b></p>",
  choices: ["开始实验"],
};

var final_screen = {
  type: jsPsychHtmlButtonResponse,
  stimulus:
    "<h3> 实验结束！</h3>\
  <p style='text-align:left'><b> 十分感谢您的参与。 </b> </p>\
  <p style='text-align:left'>您的完成码是： <b>" + participant_id + "</b></p>" +
  "<p style='text-align:left'> 请复制该完成码并发送给实验员以申报参与费。您的参与费会在确认后一周内到账。</p>\
  <p style='text-align:left'>如果有任何问题，请随时联系实验员(Shuya Chen, s2164197@ed.ac.uk)。</p>",
  choices: ["完成"],
};

var after_final = {
  type: jsPsychVideoButtonResponse,
  stimulus: [
    'video/penguin.mp4'
  ],
  choices: [],
  autoplay: true,
  trial_duration: 12000,
  width: '525px',
};


/******************************************************************************/
/*** Reading the trial list from a CSV file ***********************************/
/******************************************************************************/

/*
This function reads the trial list provided in triallist_filename (using code in a 
separate file, read_from_csv.js), and converts it to a series of jsPsych trials. 
We read the trial list in as a javascript array using read_trial_list (defined 
in read_from_csv.js). Since reading the CSV file takes some time, we have to 
use the async and await functions to ensure that the CSV file has been read before we 
start processing it. We then use build_timeline to turn the array into a list of jsPsych 
trials. 
*/

async function read_trials_and_prepare_timeline(triallist_filename) {
  var trial_list = await read_trial_list(triallist_filename);
  var production_trials = build_timeline(trial_list);
  //console.log(trial_list);
  var exercise_trials = build_exercise(exercise_list);
  //console.log(exercise_list);
  var full_timeline = [].concat(
    //preload,
    pre_consent_sreen,
    consent_screen,
    write_pp_headers,
    write_com_headers,
    instruction_screen_prepractise,
    example_trials,
    instruction_screen_btwpractise,
    exercise_trials,
    instruction_screen_postpractise,
    production_trials,
    final_screen,
    after_final
  );
  jsPsych.run(full_timeline);
}

/*
build_timeline takes a trial list read from a CSV and uses make_sentence_judgement_trial
to convert each row of that CSV file into a jsPsych trial, 
reading the relevant info from the appropriate columns in the CSV data structure.
*/
function build_timeline(trial_list) {
  var production_trials = []; 
  var trial_list_ran = jsPsych.randomization.shuffle(trial_list);
  var trial_number = 0;
  for (trial of trial_list_ran) {
      trial_number = trial_number + 1;
      var match_trial = make_pronoun_production_trial(
        trial.ori_index,
        trial.type,
        trial.verb,
        trial.bias,
        trial.list,
        trial.NP1,
        trial.NP2,
        trial.sentence,
        trial.question,
        trial.answer
      );

      //var rest_trial = make_rest_block(video);
      
      if (trial_number == 20){
        production_trials.push(match_trial);
        production_trials.push(make_rest_block('video/cat1.mp4', "三"));
      } else if (trial_number == 40) {
        production_trials.push(match_trial);
        production_trials.push(make_rest_block('video/cat2.mp4', "二"));
      } else if (trial_number == 60) {
        production_trials.push(match_trial);
        production_trials.push(make_rest_block('video/cat3.mp4', "一"));
      } else {
        production_trials.push(match_trial);
      }
  }
  return production_trials;
}

function build_exercise(trial_list) {
  var exercise_trials = [];
  for (trial of trial_list) {
      var match_trial = make_exercise_trial(
        trial.target,
        trial.question
      );
      exercise_trials.push(match_trial);
  }
  return exercise_trials;
}


/*
run everything here

read_trials_and_prepare_timeline("sentence_judgement_A.csv");
*/


/*
randomly assigning participants into four lists
*/
function random_condition() {
  var available_csvs = [
    "pronoun_production_B.csv",
    "pronoun_production_B.csv"
  ];
  var selected_csv = jsPsych.randomization.shuffle(available_csvs)[0];
  return selected_csv;
}
var this_condition = random_condition();

/*add the list with the participant id so that I can see which list they are assigned in*/
var list = this_condition.slice(18,20);
var participant_id = participant_id + list;

read_trials_and_prepare_timeline(this_condition);



  